# delimit ;
set more 1 ;
set matsize 800 ;
log using d:\postal05\bozzo\3digitmods\make2fhp.log, replace ; 
 

 
 /*  takes the fhp data by 3 digit mods operation and aggregates to fhp for incoming and outgoing sorts
        by k56 operation (the operations used in the labor demand regressions)  */
 
/*********************************************/              
/*   convert 3digit fhp data to long format  */
/*********************************************/

use d:\postal05\bozzo\3digitmods\3digitfhp.dta ;

/*  drop 3 digit mods operations that never have FHP in any year, or are cancellation operations  */

drop fhp10-fhp19 fhp66 fhp67 fhp94-fhp96 fhp98 fhp99 fhp191 fhp242 fhp244 fhp245 fhp247 fhp248 fhp250-fhp254
      fhp256 fhp279 fhp434-fhp439 fhp487-fhp489 fhp494-fhp501 fhp505-fhp507 ;
save temp, replace;

/*   convert to long format for a subset of the operations in each pass  */

keep idnum fy qtr fhp29-fhp138;
sort idnum fy qtr ;
reshape long fhp, i(idnum fy qtr) j(oper) ;
drop if fhp==0 ;
save temp1, replace ;
clear ;

use temp ;
keep idnum fy qtr fhp139-fhp259 ;
sort idnum fy qtr ;
reshape long fhp, i(idnum fy qtr) j(oper) ;
drop if fhp==0 ;
save temp2, replace ;
clear ;

use temp ;
keep idnum fy qtr fhp261-fhp296 ;
sort idnum fy qtr ;
reshape long fhp, i(idnum fy qtr) j(oper) ;
drop if fhp==0 ;
save temp3, replace ;
clear ;

use temp ;
keep idnum fy qtr fhp297-fhp481 ;
sort idnum fy qtr ;
reshape long fhp, i(idnum fy qtr) j(oper) ;
drop if fhp==0 ;
save temp4, replace ;
clear ;

use temp ;
keep idnum fy qtr fhp482-fhp819 ;
sort idnum fy qtr ;
reshape long fhp, i(idnum fy qtr) j(oper) ;
drop if fhp==0 ;
save temp5, replace ;
clear ;

use temp ;
keep idnum fy qtr fhp831-fhp872 ;
sort idnum fy qtr ;
reshape long fhp, i(idnum fy qtr) j(oper) ;
drop if fhp==0 ;
save temp6, replace ;
clear ;

use temp ;
keep idnum fy qtr fhp873-fhp979 ;
sort idnum fy qtr ;
reshape long fhp, i(idnum fy qtr) j(oper) ;
drop if fhp==0 ;
save temp7, replace ;
clear ;

use temp1 ;
append using temp2 ;
append using temp3 ;
append using temp4 ;
append using temp5 ;
append using temp6 ;
append using temp7 ;

/*   Some FHP values are negative.  At this point they can be converted to zero.  The totals will not
       match the fhp totals in the k56 data sets, because those added over the negative values  */     

gen origfhp=fhp ;
replace fhp=0 if fhp<0 ;
sort idnum fy qtr oper ;
save d:\postal05\bozzo\3digitmods\3digfhplong.dta, replace ;

sort fy qtr ;
collapse (sum) fhp origfhp, by(fy qtr) ;
replace fhp=fhp/1000 ;
replace origfhp=origfhp/1000 ;
gen error=(fhp-origfhp)/origfhp ;
list fy qtr fhp origfhp error ;
clear ;

/****************************************************************************************/
/*   construct the master list of 3 digit mods codes that are present in any year 99-04 */
/****************************************************************************************/

use d:\postal05\bozzo\3digitmods\maps99.dta ;
append using maps00.dta ;
append using maps01.dta ;
append using maps02.dta ;
append using maps03.dta ;
append using maps04.dta ;
sort oper fy ;
save maps.dta, replace ;
clear ;


/*  merge fhp data for each (plant,year,qtr,operation)  with the k137 codes  */

use d:\postal05\bozzo\3digitmods\3digfhplong.dta ;
sort oper fy ;
merge oper fy using d:\postal05\bozzo\3digitmods\maps.dta ;

/*  drop observations that have missing fhp.  these are operations that appear in maps.dta but not in 
       3digfhplong   */
       
tab _merge ;
drop if _merge==2 ;
tab oper fy ;


/*  create two fhp variables, one for incoming sort operations and one for outgoing.
     The K137 codes identify 52 categories which can be assigned to incoming and outgoing
     operations.  When K137 codes are zero (the mods category was not included with the
     data sets) we will assign the mods category based on its description  */

gen fhpout = 0 ;
replace fhpout=fhp if k137==1   | k137==5   | k137==7   | k137==8   | k137==14  | k137==15  | k137==21  | k137==22  | 
                      k137==27  | k137==28  | k137==33  | k137==34  | k137==39  | k137==40  | k137==46  | k137==48  |
                      k137==50  | k137==52  ;

replace fhpout=fhp if oper==29  | oper==46  | oper==47  | oper==50  | oper==51  | oper==52  | oper==69  | oper==138 |
                      oper==141 | oper==142 | oper==241 | oper==258 | oper==291 | oper==292 | oper==321 | oper==322 |
                      oper==421 | oper==422 | oper==450 | oper==461 | oper==462 | oper==818 | oper==831 | oper==832 |
                      oper==841 | oper==842 | oper==961 | oper==962  ;  
gen fhpin=0 ;
replace fhpin = fhp-fhpout ;

/*  aggregate to the level of the (plant,fy,qtr) and k56 operation (used in the labor demand regressions).  This
    will allow me to construct fhpin and fhpout for letters, flats, and parcels. */
    
sort idnum fy qtr k56 ;
collapse (sum) fhpin fhpout, by(idnum fy qtr k56) ;

/*   rewrite in wide format to allow merging with the regression data sets.  */

reshape wide fhpin fhpout, i(idnum fy qtr) j(k56) ;
sum ;

/*  convert fhp variables with missing values to zeros  */

replace fhpin1 =0 if fhpin1 ==. ;
replace fhpin2 =0 if fhpin2 ==. ;
replace fhpin4 =0 if fhpin4 ==. ;
replace fhpin5 =0 if fhpin5 ==. ;
replace fhpin6 =0 if fhpin6 ==. ;
replace fhpin11=0 if fhpin11==. ;
replace fhpin12=0 if fhpin12==. ;
replace fhpin13=0 if fhpin13==. ;
replace fhpin14=0 if fhpin14==. ;
replace fhpin34=0 if fhpin34==. ;
replace fhpin39=0 if fhpin39==. ;
replace fhpout1 =0 if fhpout1 ==. ;
replace fhpout2 =0 if fhpout2 ==. ;
replace fhpout4 =0 if fhpout4 ==. ;
replace fhpout5 =0 if fhpout5 ==. ;
replace fhpout6 =0 if fhpout6 ==. ;
replace fhpout11=0 if fhpout11==. ;
replace fhpout12=0 if fhpout12==. ;
replace fhpout13=0 if fhpout13==. ;
replace fhpout14=0 if fhpout14==. ;
replace fhpout34=0 if fhpout34==. ;
replace fhpout39=0 if fhpout39==. ;
gen fhpin32=fhpin1 + fhpin2 ;
gen fhpout32=fhpout1 + fhpout2 ;
gen fhpin33=fhpin5 + fhpin6 ;
gen fhpout33=fhpout5 + fhpout6 ;

/*  standardize the variable names for comparability with k56 operations  */
gen fhpin01=fhpin1 ;
gen fhpin02=fhpin2 ;
gen fhpin04=fhpin4 ;
gen fhpin05=fhpin5 ;
gen fhpin06=fhpin6 ;
gen fhpout01=fhpout1 ;
gen fhpout02=fhpout2 ;
gen fhpout04=fhpout4 ;
gen fhpout05=fhpout5 ;
gen fhpout06=fhpout6 ;

drop fhpin1 fhpin2 fhpin4 fhpin5 fhpin6 fhpout1 fhpout2 fhpout4 fhpout5 fhpout6 ;

sort idnum fy qtr ;
save d:\postal05\bozzo\3digitmods\fhp2.dta, replace ;
